@echo off

@rem The script for writing the CMPA page into LPC55Sxx
@rem Input file: %SPT_WORKSPACE%\configs\cmpa.json

@rem Environment variables - absolute paths simplifying re-use of the script on another machine
@rem  - Absolute path to SPT workspace (it is recommended to copy/move all user files in this workspace)
SETLOCAL ENABLEDELAYEDEXPANSION
if "%SPT_WORKSPACE%"=="" (
  SET "SPT_WORKSPACE=%~dp0"
  SET "SPT_WORKSPACE=!SPT_WORKSPACE:~0,-1!"
  FOR %%i in ("!SPT_WORKSPACE!") DO (
    SET "SPT_WORKSPACE=%%~dpi"
  )
  SET "SPT_WORKSPACE=!SPT_WORKSPACE:~0,-1!"
)
ENDLOCAL & SET "SPT_WORKSPACE=%SPT_WORKSPACE%"
if not exist "%SPT_WORKSPACE%\" (
  @echo FAILURE: Directory not found "%SPT_WORKSPACE%\"
  exit 2
)
@rem  - Absolute path to SPT installation directory
if "%SPT_INSTALL_BIN%"=="" (
  SET "SPT_INSTALL_BIN=C:\nxp\MCUX_Provi_v8\bin"
)
if not exist "%SPT_INSTALL_BIN%\" (
  @echo FAILURE: Directory not found "%SPT_INSTALL_BIN%\"
  exit 2
)


@rem Default connection parameters
set blhost_connect=-p COM7,115200

@rem Used command line utilities
set "blhost=%SPT_INSTALL_BIN%\tools_scripts\blhost_spsdk_win_wrapper.bat"
set "pfr=%SPT_INSTALL_BIN%\tools\spsdk\pfr.exe"

@echo ### Create CMPA page - binary ###
pushd "%SPT_WORKSPACE%"
@echo %pfr% generate-binary -c %SPT_WORKSPACE%\configs\cmpa.json -o %SPT_WORKSPACE%\configs\cmpa.bin
"%pfr%" generate-binary -c "%SPT_WORKSPACE%\configs\cmpa.json" ^
        -o "%SPT_WORKSPACE%\configs\cmpa.bin"
if errorlevel 1 (
    popd
    exit 2
)
popd

@rem Ping the device to establish communication; Result is ignored as the communication sometime fails for the first time
call "%blhost%" %blhost_connect% -j -- get-property 1 0 > nul

@echo ### Check connection ###
call "%blhost%" %blhost_connect% -j -- get-property 1 0
if errorlevel 2 exit 2

@echo ### Write Customer Manufacturing/Factory Programmable Area [CMPA] ###
call "%blhost%" %blhost_connect% -j -- write-memory 0x0003E200 "%SPT_WORKSPACE%\configs\cmpa.bin"
if errorlevel 2 exit 2